IF  EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[V_EST_NF_SAI_TRANSF_AUTOMATICA]'))
DROP VIEW [dbo].[V_EST_NF_SAI_TRANSF_AUTOMATICA]
GO

CREATE VIEW [DBO].[V_EST_NF_SAI_TRANSF_AUTOMATICA]
AS
         SELECT V.CD_EMP
          , V.CD_FILIAL
          , V.CD_FORN
          , V.CD_NF
          , V.NF_NF
          , V.CD_NF_SERIE
          , V.CD_CLI
          , V.CD_NT_MOV
          , V.VLR_TOT_PROD
          , V.VLR_ICMS
          , V.VLR_ENCG_FIN
          , V.PERC_ICMS_ENCG_FIN
          , V.VLR_DESC
          , V.VLR_IPI
          , V.VLR_BASE_SUBS
          , V.VLR_ICMS_SUBS
          , V.VLR_BASE_ICMS
          , V.VLR_FRETE
          , V.NF_IPI_BASE_CALC
          , V.STS_PED
          , V.CD_PROD
          , V.DS_PROD
          , V.CD_UN_CP
          , SUM(V.QT_IT) AS QT_IT
          , AVG(V.VLR_IT) AS VLR_IT
          , SUM(V.QT_IT * V.VLR_IT) AS VLR_TOT_IT
          , AVG(V.ALIQ_ICMS) AS ALIQ_ICMS
          , AVG(ISNULL(V.PERC_IPI, 0)) AS PERC_IPI
          , SUM(V.VLR_IPI_IT) AS VLR_IPI_IT
          , AVG(V.PERC_DESC) AS PERC_DESC
          , V.CD_TRIB
          , V.TP_MOV
          , V.VLR_NF
          , ISNULL(EST_NF_SAI_CHECKIN_ENTRADA.DT_ENT, V.DT_ENT) AS DT_ENT
          , V.DT_EMI_NF
          , V.DT_CAD
          , V.NR_NF_ENT
          , V.CD_CLI AS CD_FILIAL_DEST
          , V.PERC_IVA
          , V.QT_EMB
          , SUM(V.VLR_ICMS_IT) AS VLR_ICMS_IT
          , SUM(V.VLR_BASE_SUBS_IT) AS VLR_BASE_SUBS_IT
          , SUM(V.VLR_ICMS_SUBS_IT) AS VLR_ICMS_SUBS_IT
          , SUM(V.VLR_BASE_ICMS_IT) AS VLR_BASE_ICMS_IT
          , AVG(V.VLR_CUSTO_IT) AS VLR_CUSTO_IT
          , V.CD_NT_OP
          , SUM(V.VLR_ISENTO_IT) AS VLR_ISENTO_IT
          , SUM(V.VLR_OUTROS_IT) AS VLR_OUTROS_IT
          , V.DEST_ORIG
          , V.CD_PED
          , V.STS_NF
          , V.DS_MOV_OP
          , V.DS_MOV_OP_USUAL
          , 0 AS PROD_LIBERADO
          , SUM(V.VLR_DESC_IT) AS VLR_DESC_IT
          , 0 AS CALC_SUBS_PMC
          , 0 AS PERC_REDU_SUBS_PMC
          , 0 AS VLR_TABELA
          , ISNULL(EST_NF_SAI_CHECKIN_ENTRADA.CD_USU, 0) AS CHEKIN
          , ISNULL(V.FLAG_NAO_ANALISAR_CUSTO, 0) AS FLAG_NAO_ANALISAR_CUSTO
          , SUM(ISNULL(VLR_OUTROS_DESPESAS, 0)) AS VLR_OUTROS_DESPESAS
          , 0 AS FLAG_GERAR_CROSS
          , V.UNID
          , 0 AS TP_TRANSF_VENDA_GRUPO
          , CASE WHEN ISNULL(W.CD_MOV_OP, 0) = 0 THEN CASE
				WHEN ISNULL(EST_NF_SAI_CHECKIN_ENTRADA.CD_MOV_OP, 0) = 0 THEN 
					CASE WHEN ISNULL(CD_NT_OP_TRANSF_ENTRADA, 0) = 0 THEN 
						CASE WHEN ISNULL(GLB_MOV_OP_CONF_DEVO_SAIDA.CD_MOV_OP_DEV, 0) = 0 THEN
							CASE WHEN TP_MOV = 10 THEN 
								ISNULL(RSPAR.VALOR, 0)
							WHEN TP_MOV = 23 THEN 
								ISNULL(RSPARCONSUMO.VALOR, 0)
							WHEN TP_MOV = 26 THEN 
								ISNULL(RSPARATIVO.VALOR, 0)
							ELSE 
								0 --NAO DEFINIDO, ANALISAR E DEFINIR O CORRETO
							END
						ELSE
							ISNULL(GLB_MOV_OP_CONF_DEVO_SAIDA.CD_MOV_OP_DEV, 0)
						END
					ELSE 
						ISNULL(CD_NT_OP_TRANSF_ENTRADA, 0)
					END
				ELSE 
					EST_NF_SAI_CHECKIN_ENTRADA.CD_MOV_OP
				END
            ELSE 
				ISNULL(W.CD_MOV_OP, 0)
            END AS CD_NT_MOV_ENTRADA
          , ISNULL(V_EST_PROD_PRECO_TBL.VLR_VD, 0) AS VLR_PROD_PMC
          , ISNULL(V.FLAG_NAO_CREDITAR_IMPOSTO, 0) AS FLAG_NAO_CREDITAR_IMPOSTO
          , V.APRES_EMB_CP
          , V.APRES_QT_CP
          , V.FLAG_IGNORAR_PMC_SUBST
          , V.CTR_PMC
          , V.PERC_REDU_BASE_SUBS
          , V.PERC_REDU_BASE_ICMS
          , ISNULL(V.VLR_PROD_FRETE, 0) AS VLR_PROD_FRETE
          , ISNULL(V.VLR_BASE_PIS, 0) AS VLR_BASE_PIS
          , ISNULL(V.VLR_PIS, 0) AS VLR_PIS
          , ISNULL(V.VLR_BASE_COFINS, 0) AS VLR_BASE_COFINS
          , ISNULL(V.VLR_COFINS, 0) AS VLR_COFINS
          , V.TP_SR_NFE
          , V.NFE_VALIDADA
          , 0 AS VLR_DESC_FINAN
          , 0 AS PERC_DESC_FINAN
          , PRC_FILIAL.CTR_LOTE AS CTR_LOTE_FILIAL
          , AVG(VLR_CUSTO_GERENCIAL_TRANSF) AS VLR_CUSTO_GERENCIAL_TRANSF
          , SUM(V.VLR_BASE_ICMS_RET) AS VLR_BASE_ICMS_RET
          , SUM(V.VLR_ICMS_RET) AS VLR_ICMS_RET
          , V.FLAG_PERMITE_RESSARCIMENTO_ICMS
          , EST_PROD.NR_NCM
          , V.VLR_CUSTO_ACERTO
          , V.PERC_ALIQ_PIS
          , V.PERC_ALIQ_COFINS
          , V.VLR_ICMS_DESONERADO AS VLR_ICMS_DESONERADO
          , V.ICMS_DESONERADO_MOTIVO AS ICMS_DESONERADO_MOTIVO
          , V.CD_BENEF AS CD_BENEF
          , V.ALIQ_ICMS_INTERNO
          , 0 AS PERC_DIFERIMENTO
          , 0 AS VLR_ICMS_DIFERIMENTO
		 , 0 AS VLR_BASE_ICMS_OP
		 , 0 AS VLR_ICMS_OP
		 , 0 AS PERC_ICMS_RET
		 , 1 AS FLAG_ICMS_SUBST_PAGO_ANTERIOR
		 , ISNULL(V.VLR_BASE_FECOP_ST,0) AS VLR_BASE_FECOP_ST
	     , ISNULL(V.PERC_FECOP_ST,0) AS    PERC_FECOP_ST
	     , ISNULL(V.VLR_FECOP_ST,0) AS     VLR_FECOP_ST
	     , ISNULL(V.CAB_VLR_FECOP_ST,0) AS     CAB_VLR_FECOP_ST

         , ISNULL(V.VLR_BASE_FECOP,0) AS VLR_BASE_FECOP
	     , ISNULL(V.PERC_FECOP,0) AS    PERC_FECOP
	     , ISNULL(V.VLR_FECOP,0) AS     VLR_FECOP
	     , ISNULL(V.CAB_VLR_FECOP,0) AS     CAB_VLR_FECOP

         , ISNULL(V.VLR_BASE_FECOP_ST_RET,0) AS VLR_BASE_FECOP_ST_RET
	     , ISNULL(V.PERC_FECOP_ST_RET,0) AS    PERC_FECOP_ST_RET
	     , ISNULL(V.VLR_FECOP_ST_RET,0) AS     VLR_FECOP_ST_RET
	     , ISNULL(V.CAB_VLR_FECOP_ST_RET,0) AS     CAB_VLR_FECOP_ST_RET
         , EST_PROD_CPL.TP_PROD
         ,ISNULL(V.FLAG_NAO_ABATER_ICMS_DESONERADO, 1) AS FLAG_NAO_ABATER_ICMS_DESONERADO
         , ISNULL (V.VLR_CUSTO_PROD_ORIG, 0) AS VLR_CUSTO_PROD_ORIG
		 , COALESCE (EST_PROD.FLAG_ORIG_PROD_NF_ENT, 0) AS FLAG_ORIG_PROD_NF_ENT
		 ,v.CD_IT
      FROM
         V_EST_NF_SAI_TRANSF V
         INNER JOIN EST_NF_SAI_CHECKIN_ENTRADA
         ON V.CD_EMP = EST_NF_SAI_CHECKIN_ENTRADA.CD_EMP
            AND V.CD_FILIAL = EST_NF_SAI_CHECKIN_ENTRADA.CD_FILIAL
            AND V.CD_NF = EST_NF_SAI_CHECKIN_ENTRADA.CD_NF
         LEFT OUTER JOIN EST_NF_SAI_EST_WMS_ENT W
         ON V.CD_EMP = W.CD_EMP
            AND V.CD_FILIAL = W.CD_FILIAL_ORIG
            AND V.CD_NF = W.CD_NF_ORIG
         LEFT OUTER JOIN V_EST_PROD_PRECO_TBL
         ON V.CD_EMP = V_EST_PROD_PRECO_TBL.CD_EMP
            AND V.CD_FILIAL = V_EST_PROD_PRECO_TBL.CD_FILIAL
            AND V.CD_PROD = V_EST_PROD_PRECO_TBL.CD_PROD
         LEFT OUTER JOIN (
			SELECT
				GLB_MOV_OP_CONF_DEVO_SAIDA.CD_MOV_OP,
				MAX(CD_MOV_OP_DEV) AS CD_MOV_OP_DEV
			FROM
				GLB_MOV_OP_CONF_DEVO_SAIDA
				INNER JOIN GLB_MOV_OP ON
					GLB_MOV_OP_CONF_DEVO_SAIDA.CD_MOV_OP_DEV = GLB_MOV_OP.CD_MOV_OP
			WHERE
				  GLB_MOV_OP.TP_MOV = 10
				  AND GLB_MOV_OP.STS_MOV = 0
				  AND '1' = ISNULL((SELECT ISNULL(VALOR, '0')FROM PRC_EMP_CONFIG WHERE CD_EMP = 1 AND CD_CHAVE = 'UTILIZA_CONFIG_MOV_SAIDA_ENTRADA_TRANSF'), '0')
			GROUP BY
				GLB_MOV_OP_CONF_DEVO_SAIDA.CD_MOV_OP) GLB_MOV_OP_CONF_DEVO_SAIDA ON
			 V.CD_NT_MOV = GLB_MOV_OP_CONF_DEVO_SAIDA.CD_MOV_OP
         LEFT OUTER JOIN
         (
         SELECT CD_EMP
              , CD_FILIAL
              , VALOR
         FROM PRC_FILIAL_CONFIG
         WHERE CD_CHAVE = 'CD_MOV_OP_TRANSF_FILIAIS_ENT'
     ) RSPAR
         ON V.CD_EMP = RSPAR.CD_EMP
            AND V.CD_CLI = RSPAR.CD_FILIAL
         LEFT OUTER JOIN
         (
         SELECT CD_EMP
              , CD_FILIAL
              , VALOR
         FROM PRC_FILIAL_CONFIG
         WHERE CD_CHAVE = 'CD_MOV_OP_TRANSF_FILIAL_CONSUMO_ENT'
     ) RSPARCONSUMO
         ON V.CD_EMP = RSPARCONSUMO.CD_EMP
            AND V.CD_CLI = RSPARCONSUMO.CD_FILIAL
         LEFT OUTER JOIN
         (
         SELECT CD_EMP
              , CD_FILIAL
              , VALOR
         FROM PRC_FILIAL_CONFIG
         WHERE CD_CHAVE = 'CD_MOV_OP_TRANSF_FILIAL_ATIVO_IMOB_ENT'
     ) RSPARATIVO
         ON V.CD_EMP = RSPARATIVO.CD_EMP
            AND V.CD_CLI = RSPARATIVO.CD_FILIAL
         INNER JOIN PRC_FILIAL
         ON V.CD_EMP = PRC_FILIAL.CD_EMP
            AND V.CD_CLI = PRC_FILIAL.CD_FILIAL
         INNER JOIN EST_NF_SERIE
         ON V.CD_EMP = EST_NF_SERIE.CD_EMP
            AND V.CD_NF_SERIE = EST_NF_SERIE.CD_NF_SERIE
         LEFT OUTER JOIN EST_NF_SAI_NFE
         ON V.CD_EMP = EST_NF_SAI_NFE.CD_EMP
            AND V.CD_FILIAL = EST_NF_SAI_NFE.CD_FILIAL
            AND V.CD_NF = EST_NF_SAI_NFE.CD_NF
         INNER JOIN EST_PROD
         ON V.CD_EMP = EST_PROD.CD_EMP
            AND V.CD_PROD = EST_PROD.CD_PROD
         INNER JOIN EST_PROD_CPL
         ON V.CD_EMP = EST_PROD_CPL.CD_EMP
            AND V.CD_FILIAL = EST_PROD_CPL.CD_FILIAL
            AND V.CD_PROD = EST_PROD_CPL.CD_PROD
      WHERE PRC_FILIAL.FLAG_NOTA_FISCAL_ENTRADA_AUTOMATICA = 1
      GROUP BY V.CD_EMP
            , V.CD_FILIAL
            , V.CD_FORN
            , V.CD_NF
            , V.CD_NF_SERIE
            , V.NF_NF
            , V.CD_CLI
            , V.CD_NT_MOV
            , V.VLR_TOT_PROD
            , V.VLR_ICMS
            , V.VLR_ENCG_FIN
            , V.PERC_ICMS_ENCG_FIN
            , V.VLR_DESC
            , V.VLR_IPI
            , V.VLR_BASE_SUBS
            , V.VLR_ICMS_SUBS
            , V.VLR_BASE_ICMS
            , V.VLR_FRETE
            , V.NF_IPI_BASE_CALC
            , V.STS_PED
            , V.CD_PROD
            , V.DS_PROD
            , V.CD_UN_CP
            , V.CD_TRIB
            , V.TP_MOV
            , V.VLR_NF
            , EST_NF_SAI_CHECKIN_ENTRADA.DT_ENT
            , V.DT_ENT
            , V.DT_EMI_NF
            , V.NR_NF_ENT
            , V.PERC_IVA
            , V.QT_EMB
            , V.CD_NT_OP
            , V.DEST_ORIG
            , V.CD_PED
            , V.STS_NF
            , V.DS_MOV_OP
            , V.DS_MOV_OP_USUAL
            , V.PROD_LIBERADO
            , EST_NF_SAI_CHECKIN_ENTRADA.CD_USU
            , V.FLAG_NAO_ANALISAR_CUSTO
            , V.DT_CAD
            , V.UNID
            , RSPAR.VALOR
            , V_EST_PROD_PRECO_TBL.VLR_VD
            , V.FLAG_NAO_CREDITAR_IMPOSTO
            , V.APRES_EMB_CP
            , V.APRES_QT_CP
            , V.FLAG_IGNORAR_PMC_SUBST
            , V.CTR_PMC
            , V.PERC_REDU_BASE_SUBS
            , V.PERC_REDU_BASE_ICMS
            , V.VLR_PROD_FRETE
            , V.VLR_BASE_PIS
            , V.VLR_PIS
            , V.VLR_BASE_COFINS
            , V.VLR_COFINS
            , RSPARCONSUMO.VALOR
            , V.CD_NT_OP_TRANSF_ENTRADA
			, GLB_MOV_OP_CONF_DEVO_SAIDA.CD_MOV_OP_DEV
            , V.TP_SR_NFE
            , V.NFE_VALIDADA
            , PRC_FILIAL.CTR_LOTE
            , W.CD_MOV_OP
            , RSPARATIVO.VALOR
            , V.FLAG_PERMITE_RESSARCIMENTO_ICMS
            , EST_NF_SAI_CHECKIN_ENTRADA.CD_MOV_OP
            , EST_PROD.NR_NCM
            , V.VLR_CUSTO_ACERTO
            , V.PERC_ALIQ_PIS
            , V.PERC_ALIQ_COFINS
            , V.ALIQ_ICMS_INTERNO
			, V.VLR_BASE_FECOP_ST
			, V.PERC_FECOP_ST
			, V.VLR_FECOP_ST
			, V.CAB_VLR_FECOP_ST
			, V.VLR_ICMS_DESONERADO
			, V.ICMS_DESONERADO_MOTIVO
            , V.CD_BENEF 
            , V.VLR_BASE_FECOP
            , V.PERC_FECOP
            , V.VLR_FECOP
            , V.CAB_VLR_FECOP
            , V.VLR_BASE_FECOP_ST_RET
            , V.PERC_FECOP_ST_RET
            , V.VLR_FECOP_ST_RET
            , V.CAB_VLR_FECOP_ST_RET
            , EST_PROD_CPL.TP_PROD
            , V.FLAG_NAO_ABATER_ICMS_DESONERADO
            , V.VLR_CUSTO_PROD_ORIG
			, EST_PROD.FLAG_ORIG_PROD_NF_ENT
			,v.CD_IT



   UNION ALL
      --VENDA
      SELECT V.CD_EMP
          , V.CD_FILIAL
          , CASE
                WHEN ISNULL(OPE.DEST_ORIG, 2) = 0
                THEN -- CLIENTE
              C.CD_CLI
                WHEN ISNULL(OPE.DEST_ORIG, 2) = 1
                THEN  -- FORNE
              F.CD_FORN
                WHEN ISNULL(OPE.DEST_ORIG, 2) = 2
                THEN    -- FILIAL
              V.CD_FILIAL
                ELSE V.CD_FORN
            END CD_FORN
          , V.CD_NF
          , V.NF_NF
          , V.CD_NF_SERIE
          , V.CD_CLI
          , V.CD_NT_MOV
          , V.VLR_TOT_PROD
          , V.VLR_ICMS
          , V.VLR_ENCG_FIN
          , V.PERC_ICMS_ENCG_FIN
          , V.VLR_DESC
          , V.VLR_IPI
          , V.VLR_BASE_SUBS
          , V.VLR_ICMS_SUBS
          , V.VLR_BASE_ICMS
          , V.VLR_FRETE
          , V.NF_IPI_BASE_CALC
          , V.STS_PED
          , V.CD_PROD
          , V.DS_PROD
          , V.CD_UN_CP
          , V.QT_IT
          , V.VLR_IT
          , V.VLR_TOT_IT
          , V.ALIQ_ICMS
          , V.PERC_IPI
          , V.VLR_IPI_IT
          , V.PERC_DESC
          , V.CD_TRIB
          , V.TP_MOV
          , V.VLR_NF
          , ISNULL(EST_NF_SAI_CHECKIN_ENTRADA.DT_ENT, V.DT_ENT) AS DT_ENT
          , V.DT_EMI_NF
          , V.DT_CAD
          , V.NR_NF_ENT
          , V.CD_FILIAL_DEST
          , V.PERC_IVA
          , V.QT_EMB
          , V.VLR_ICMS_IT
          , V.VLR_BASE_SUBS_IT
          , V.VLR_ICMS_SUBS_IT
          , V.VLR_BASE_ICMS_IT
          , V.VLR_CUSTO_IT
          , V.CD_NT_OP
          , V.VLR_ISENTO_IT
          , V.VLR_OUTROS_IT
          , V.DEST_ORIG
          , 0 AS CD_PED
          , V.STS_NF
          , V.DS_MOV_OP
          , V.DS_MOV_OP_USUAL
          , V.PROD_LIBERADO
          , ISNULL(V.VLR_DESC_IT, 0) AS VLR_DESC_IT
          , 0 AS CALC_SUBS_PMC
          , 0 AS PERC_REDU_SUBS_PMC
          , 0 AS VLR_TABELA
          , ISNULL(EST_NF_SAI_CHECKIN_ENTRADA.CD_USU, 0) AS CHEKIN
          , V.FLAG_NAO_ANALISAR_CUSTO
          , (SELECT
            SUM (ISNULL((VLR_OUTROS_DESPESAS),0))
         FROM
            V_EST_NF_SAI_TRANSF_PRC_FILIAL_RC_CLI V
         WHERE 
				V.CD_EMP =EST_NF_SAI_CHECKIN_ENTRADA.CD_EMP AND
            V.CD_FILIAL =EST_NF_SAI_CHECKIN_ENTRADA.CD_FILIAL AND
            V.CD_NF =EST_NF_SAI_CHECKIN_ENTRADA.CD_NF ) AS VLR_OUTROS_DESPESAS

          , 0 AS FLAG_GERAR_CROSS
          , V.UNID
          , 1 AS TP_TRANSF_VENDA_GRUPO
          , OPE.CD_MOV_OP AS CD_NT_MOV_ENTRADA
          , ISNULL(V_EST_PROD_PRECO_TBL.VLR_VD, 0) AS VLR_PROD_PMC
          , ISNULL(V.FLAG_NAO_CREDITAR_IMPOSTO, 0) AS FLAG_NAO_CREDITAR_IMPOSTO
          , V.APRES_EMB_CP
          , V.APRES_QT_CP
          , V.FLAG_IGNORAR_PMC_SUBST
          , V.CTR_PMC
          , V.PERC_REDU_BASE_SUBS
          , V.PERC_REDU_BASE_ICMS
          , ISNULL(V.VLR_PROD_FRETE, 0) AS VLR_PROD_FRETE
          , ISNULL(V.VLR_BASE_PIS, 0) AS VLR_BASE_PIS
          , ISNULL(V.VLR_PIS, 0) AS VLR_PIS
          , ISNULL(V.VLR_BASE_COFINS, 0) AS VLR_BASE_COFINS
          , ISNULL(V.VLR_COFINS, 0) AS VLR_COFINS
          , V.TP_SR_NFE
          , V.NFE_VALIDADA
          , 0 AS VLR_DESC_FINAN
          , 0 AS PERC_DESC_FINAN
          , PRC_FILIAL.CTR_LOTE AS CTR_LOTE_FILIAL
          , VLR_CUSTO_GERENCIAL_TRANSF
          , ISNULL(V.VLR_BASE_ICMS_RET, 0) AS VLR_BASE_ICMS_RET
          , ISNULL(V.VLR_ICMS_RET, 0) AS VLR_ICMS_RET
          , V.FLAG_PERMITE_RESSARCIMENTO_ICMS
          , EST_PROD.NR_NCM
          , V.VLR_CUSTO_ACERTO
          , V.PERC_ALIQ_PIS
          , V.PERC_ALIQ_COFINS
		  , V.VLR_ICMS_DESONERADO AS VLR_ICMS_DESONERADO
          , V.ICMS_DESONERADO_MOTIVO AS ICMS_DESONERADO_MOTIVO
          , V.CD_BENEF AS CD_BENEF
          , V.ALIQ_ICMS_INTERNO
		, 0 AS PERC_DIFERIMENTO
          , 0 AS VLR_ICMS_DIFERIMENTO
		, 0 AS VLR_BASE_ICMS_OP
		, 0 AS VLR_ICMS_OP
		, 0 AS PERC_ICMS_RET
		, 1 AS FLAG_ICMS_SUBST_PAGO_ANTERIOR
        , ISNULL(V.VLR_BASE_FECOP_ST,0) AS VLR_BASE_FECOP_ST
        , ISNULL(V.PERC_FECOP_ST,0) AS    PERC_FECOP_ST
        , ISNULL(V.VLR_FECOP_ST,0) AS     VLR_FECOP_ST
        , ISNULL(V.CAB_VLR_FECOP_ST,0) AS     CAB_VLR_FECOP_ST

        , ISNULL(V.VLR_BASE_FECOP,0) AS VLR_BASE_FECOP
        , ISNULL(V.PERC_FECOP,0) AS    PERC_FECOP
        , ISNULL(V.VLR_FECOP,0) AS     VLR_FECOP
        , ISNULL(V.CAB_VLR_FECOP,0) AS     CAB_VLR_FECOP

        , ISNULL(V.VLR_BASE_FECOP_ST_RET,0) AS VLR_BASE_FECOP_ST_RET
        , ISNULL(V.PERC_FECOP_ST_RET,0) AS    PERC_FECOP_ST_RET
        , ISNULL(V.VLR_FECOP_ST_RET,0) AS     VLR_FECOP_ST_RET
        , ISNULL(V.CAB_VLR_FECOP_ST_RET,0) AS     CAB_VLR_FECOP_ST_RET
        , EST_PROD_CPL.TP_PROD
        , ISNULL(V.FLAG_NAO_ABATER_ICMS_DESONERADO, 1) AS FLAG_NAO_ABATER_ICMS_DESONERADO
        , ISNULL (V.VLR_CUSTO_PROD_ORIG, 0) AS VLR_CUSTO_PROD_ORIG
		, COALESCE (EST_PROD.FLAG_ORIG_PROD_NF_ENT, 0) AS FLAG_ORIG_PROD_NF_ENT
		,v.CD_IT
      FROM
         V_EST_NF_SAI_TRANSF_PRC_FILIAL_RC_CLI V
         INNER JOIN EST_NF_SAI_CHECKIN_ENTRADA
         ON V.CD_EMP = EST_NF_SAI_CHECKIN_ENTRADA.CD_EMP
            AND V.CD_FILIAL = EST_NF_SAI_CHECKIN_ENTRADA.CD_FILIAL
            AND V.CD_NF = EST_NF_SAI_CHECKIN_ENTRADA.CD_NF
         INNER JOIN PRC_FILIAL_PG_FORN F
         ON V.CD_EMP = F.CD_EMP
            AND V.CD_FILIAL = F.CD_FILIAL
         INNER JOIN PRC_FILIAL_RC_CLI C
         ON V.CD_EMP = C.CD_EMP
            AND V.CD_FILIAL = C.CD_FILIAL
        INNER JOIN EST_PROD_CPL
         ON V.CD_EMP = EST_PROD_CPL.CD_EMP
            AND V.CD_FILIAL = EST_PROD_CPL.CD_FILIAL
            AND V.CD_PROD = EST_PROD_CPL.CD_PROD
         LEFT OUTER JOIN V_EST_PROD_PRECO_TBL
         ON V.CD_EMP = V_EST_PROD_PRECO_TBL.CD_EMP
            AND V.CD_FILIAL = V_EST_PROD_PRECO_TBL.CD_FILIAL
            AND V.CD_PROD = V_EST_PROD_PRECO_TBL.CD_PROD
        LEFT OUTER JOIN (
			SELECT
				GLB_MOV_OP_CONF_DEVO_SAIDA.CD_MOV_OP,
				MAX(CD_MOV_OP_DEV) AS CD_MOV_OP_DEV
			FROM
				GLB_MOV_OP_CONF_DEVO_SAIDA
				INNER JOIN GLB_MOV_OP ON
					GLB_MOV_OP_CONF_DEVO_SAIDA.CD_MOV_OP_DEV = GLB_MOV_OP.CD_MOV_OP
			WHERE
				GLB_MOV_OP.TP_MOV = 10
			GROUP BY
				GLB_MOV_OP_CONF_DEVO_SAIDA.CD_MOV_OP) GLB_MOV_OP_CONF_DEVO_SAIDA ON
			 V.CD_NT_MOV = GLB_MOV_OP_CONF_DEVO_SAIDA.CD_MOV_OP
         LEFT OUTER JOIN
         (
         SELECT CD_EMP
              , CD_FILIAL
              , VALOR
         FROM PRC_FILIAL_CONFIG
         WHERE CD_CHAVE = 'CD_MOV_OP_VENDA_GRP_ECON_ENT'
     ) RSPAR
         ON V.CD_EMP = RSPAR.CD_EMP
            AND V.CD_CLI = RSPAR.CD_FILIAL
         LEFT OUTER JOIN EST_NF_SAI_EST_WMS_ENT W
         ON V.CD_EMP = W.CD_EMP
            AND V.CD_FILIAL = W.CD_FILIAL_ORIG
            AND V.CD_NF = W.CD_NF_ORIG
         LEFT JOIN GLB_MOV_OP O
         ON RSPAR.VALOR = O.CD_MOV_OP
         INNER JOIN PRC_FILIAL
         ON V.CD_EMP = PRC_FILIAL.CD_EMP
            AND V.CD_FILIAL_DEST = PRC_FILIAL.CD_FILIAL
         INNER JOIN EST_PROD
         ON V.CD_EMP = EST_PROD.CD_EMP
            AND V.CD_PROD = EST_PROD.CD_PROD
         INNER JOIN GLB_MOV_OP OPE
         ON OPE.CD_MOV_OP = CASE
                                 WHEN ISNULL(W.CD_MOV_OP, 0) = 0
                                 THEN CASE
                                          WHEN ISNULL(EST_NF_SAI_CHECKIN_ENTRADA.CD_MOV_OP, 0) = 0
                                          THEN CASE
                                                   WHEN ISNULL(CD_NT_OP_TRANSF_ENTRADA, 0) = 0
                                                   THEN ISNULL(RSPAR.VALOR, 0)
                                                   ELSE ISNULL(CD_NT_OP_TRANSF_ENTRADA, 0)
                                               END
                                          ELSE EST_NF_SAI_CHECKIN_ENTRADA.CD_MOV_OP
                                      END
                                 ELSE ISNULL(W.CD_MOV_OP, 0)
                             END
      WHERE PRC_FILIAL.FLAG_NOTA_FISCAL_ENTRADA_AUTOMATICA = 1;
